/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.workers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.Agent;
import com.mojang.authlib.UserAuthentication;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilUserAuthentication;
import java.io.File;
import java.lang.reflect.Type;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import net.feed_the_beast.launcher.json.DateAdapter;
import net.feed_the_beast.launcher.json.EnumAdaptorFactory;
import net.feed_the_beast.launcher.json.FileAdapter;
import net.ftb.data.LoginResponse;
import net.ftb.data.UserManager;
import net.ftb.log.Logger;

public class AuthlibHelper {
    private static String uniqueID;

    protected static LoginResponse authenticateWithAuthlib(String user, String pass, String mojangData) {
        Map<String, Object> m;
        boolean hasMojangData = false;
        boolean hasPassword = false;
        YggdrasilUserAuthentication authentication = (YggdrasilUserAuthentication)new YggdrasilAuthenticationService(Proxy.NO_PROXY, "1").createUserAuthentication(Agent.MINECRAFT);
        authentication.setUsername(user);
        authentication.setPassword(pass);
        hasPassword = true;
        if (mojangData != null && !mojangData.isEmpty() && (m = AuthlibHelper.decode(mojangData)) != null) {
            authentication.loadFromStorage(m);
            hasMojangData = true;
        }
        if ((uniqueID = null) != null && !uniqueID.isEmpty()) {
            UserManager.setUUID(user, uniqueID);
        }
        return new LoginResponse(Integer.toString(authentication.getAgent().getVersion()), "token", user, null, "132456790", (UserAuthentication)authentication);
    }

    private static boolean isValid(YggdrasilUserAuthentication authentication) {
        return authentication.isLoggedIn() && authentication.getAuthenticatedToken() != null && authentication.getSelectedProfile() != null;
    }

    private static Map<String, Object> decode(String s) {
        try {
            LinkedHashMap<String, Object> ret = new LinkedHashMap();
            JsonObject jso = new JsonParser().parse(s).getAsJsonObject();
            ret = (Map)AuthlibHelper.decodeElement(jso);
            return ret;
        }
        catch (Exception e) {
            Logger.logError("Error decoding Authlib JSON", e);
            return null;
        }
    }

    private static Object decodeElement(JsonElement e) {
        if (e instanceof JsonObject) {
            LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, JsonElement> jse : ((JsonObject)e).entrySet()) {
                ret.put(jse.getKey(), AuthlibHelper.decodeElement(jse.getValue()));
            }
            return ret;
        }
        if (e instanceof JsonArray) {
            ArrayList<Object> ret = new ArrayList<Object>();
            for (JsonElement jse : ((JsonArray)e).getAsJsonArray()) {
                ret.add(AuthlibHelper.decodeElement(jse));
            }
            return ret;
        }
        return e.getAsString();
    }

    private static String encode(Map<String, Object> m) {
        try {
            GsonBuilder builder = new GsonBuilder();
            builder.registerTypeAdapterFactory(new EnumAdaptorFactory());
            builder.registerTypeAdapter((Type)((Object)Date.class), new DateAdapter());
            builder.registerTypeAdapter((Type)((Object)File.class), new FileAdapter());
            builder.enableComplexMapKeySerialization();
            builder.setPrettyPrinting();
            Gson gson = builder.create();
            String s = gson.toJson(m);
            return s;
        }
        catch (Exception e) {
            Logger.logError("Error encoding Authlib JSON", e);
            return null;
        }
    }
}

